program masyvas_sar;

const N = 9;

{ paprasta struktura }
type struktura = record
                   i1 : integer;
                   i2 : integer;
                   r1 : real;
                   r2 : real
                 end;

{ dvikryptis sarasas }
type sarasas2kr = ^irasas2kr;
     irasas2kr = record
                   str : struktura;
                   ankst : sarasas2kr;
                   kitas : sarasas2kr
                 end;

{ struktura 'studentas' }
type studentas = record
                   vardas : string;
                   pavarde : string;
                   stud_paz_nr : integer;
                   specialybe : string;
                   kursas : integer;
                   grupe : integer;
                   login : string
                 end;

{------------------------------------------------------------}

{ saraso spausdinimas nuo pradzios }
procedure spausdinti_sar2kr_pr (s : sarasas2kr);
begin
  while s <> nil do
  begin
    // write (' ', s^.str.i1, '-', s^.str.i2, '-', s^.str.r1:2:2, '-', s^.str.r2:2:2);
    write (' ', s^.str.i1, '-', s^.str.i2);
    s := s^.kitas
  end;
  writeln
end;

{ saraso spausdinimas nuo pabaigos }
procedure spausdinti_sar2kr_pab (s : sarasas2kr);
begin
  while s <> nil do
  begin
    // write (' ', s^.str.i1, '-', s^.str.i2, '-', s^.str.r1:2:2, '-', s^.str.r2:2:2);
    write (' ', s^.str.i1, '-', s^.str.i2);
    s := s^.ankst
  end;
  writeln
end;

{ iterpimas i saraso pradzia }
procedure iterpti_sar2kr_pr (var spr, spb : sarasas2kr; pi1, pi2 : integer; pr1, pr2 : real);
  var p : sarasas2kr;
begin
  new (p);
  p^.str.i1 := pi1;
  p^.str.i2 := pi2;
  p^.str.r1 := pr1;
  p^.str.r2 := pr2;
  p^.ankst := nil;
  p^.kitas := spr;

  if spr = nil then
  begin
    spr := p;
    spb := p
  end
  else begin
         spr^.ankst := p;
         spr := p
       end
end;

{ iterpimas i saraso pabaiga }
procedure iterpti_sar2kr_pab (var spr, spb : sarasas2kr; pi1, pi2 : integer; pr1, pr2 : real);
  var p : sarasas2kr;
begin
  new (p);
  p^.str.i1 := pi1;
  p^.str.i2 := pi2;
  p^.str.r1 := pr1;
  p^.str.r2 := pr2;
  p^.ankst := spb;
  p^.kitas := nil;

  if spb = nil then
  begin
    spr := p;
    spb := p
  end
  else begin
         spb^.kitas := p;
         spb := p
       end
end;

{ ismetimas is saraso pradzios }
procedure ismesti_sar2kr_pr (var spr, spb : sarasas2kr);
  var p : sarasas2kr;
begin
  if spr <> nil then
  begin
    p := spr;
    spr := spr^.kitas;
    dispose (p);
    if spr <> nil then spr^.ankst := nil
                  else spb := nil
  end
end;

{ ismetimas is saraso pabaigos }
procedure ismesti_sar2kr_pab (var spr, spb : sarasas2kr);
  var p : sarasas2kr;
begin
  if spb <> nil then
  begin
    p := spb;
    spb := spb^.ankst;
    dispose (p);
    if spb <> nil then spb^.kitas := nil
                  else spr := nil
  end
end;

{------------------------------------------------------------}

{ saraso inicializacija }
procedure inicializuoti_sar (var spr, spb : sarasas2kr);
begin
  while spr <> nil do ismesti_sar2kr_pab (spr, spb);
end;

{ skaiciaus sarase suradimas }
function rasti_sar2kr (s : sarasas2kr; sk1, sk2 : integer) : boolean;
  var b : boolean;
begin
  b := false;
  while s <> nil do
  begin
    if (s^.str.i1 = sk1) or (s^.str.i2 = sk2) then
    begin
      b := true;
      break
    end;
    s := s^.kitas
  end;
  rasti_sar2kr := b
end;

{ saraso uzpildymas }
procedure uzpildyti_sar2kr (var spr, spb : sarasas2kr);
  var i, val1, val2 : integer;
begin
  inicializuoti_sar (spr, spb);
  randomize;
  for i := 1 to N do
  begin
    repeat
      val1 := 1 + random (99);
      val2 := 1 + random (99);
    until not rasti_sar2kr(spr, val1, val2);
    iterpti_sar2kr_pab (spr, spb, val1, val2, 0, 0)
  end
end;

{ saraso elementu skaicius }
function skaicius_sar (s : sarasas2kr) : integer;
  var cnt : integer;
begin
  cnt := 0;
  while s <> nil do
  begin
    cnt := cnt + 1;
    s := s^.kitas
  end;
  skaicius_sar := cnt
end;

{ gauti i-taji saraso elementa }
function elementas_sar_gauti (s : sarasas2kr; pi : integer) : struktura;
  var kstr : struktura;
      i : integer;
begin
  kstr.i1 := 0;
  kstr.i2 := 0;
  kstr.r1 := 0;
  kstr.r2 := 0;
  i := 1;
  while (s <> nil) and (i <> pi) do
  begin
    i := i + 1;
    s := s^.kitas
  end;
  if s <> nil then kstr := s^.str;
  elementas_sar_gauti := kstr
end;

{ priskirti i-taji saraso elementa }
procedure elementas_sar_prisk (s : sarasas2kr; pi : integer; pstr : struktura);
  var i : integer;
begin
  i := 1;
  while (s <> nil) and (i <> pi) do
  begin
    i := i + 1;
    s := s^.kitas
  end;
  if s <> nil then s^.str := pstr
end;

{ burbulas didejanciai masyvui-sarasui }
procedure bubble_mas_sar_did (spr, spb : sarasas2kr);
  var i, j : integer;
      t : struktura;
begin
  writeln ('Rusiuojam didejanciai masyva-sarasa...pradzia');
{
  for i := N downto 1 do
    for j := 2 to i do
      if str[j-1].i1 > str[j].i1 then
        begin
          t := str[j-1];
          str[j-1] := str[j];
          str[j] := t;
          spausdinti_str ()
        end;
}
  for i := N downto 1 do
    for j := 2 to i do
      if elementas_sar_gauti(spr, j-1).i1 > elementas_sar_gauti(spr, j).i1 then
        begin
          t := elementas_sar_gauti(spr, j-1);
          elementas_sar_prisk (spr, j-1, elementas_sar_gauti(spr, j));
          elementas_sar_prisk (spr, j, t);
          spausdinti_sar2kr_pr (spr)
        end;

  writeln ('Rusiuojam didejanciai masyva-sarasa...pabaiga')
end;

{ burbulas mazejanciai masyvui-sarasui }
procedure bubble_mas_sar_maz (spr, spb : sarasas2kr);
  var i, j : integer;
      t : struktura;
begin
  writeln ('Rusiuojam mazejanciai masyva-sarasa...pradzia');
{
  for i := N downto 1 do
    for j := 2 to i do
      if str[j-1].i2 < str[j].i2 then
        begin
          t := str[j-1];
          str[j-1] := str[j];
          str[j] := t;
          spausdinti_str ()
        end;
}
  for i := N downto 1 do
    for j := 2 to i do
      if elementas_sar_gauti(spr, j-1).i2 < elementas_sar_gauti(spr, j).i2 then
        begin
          t := elementas_sar_gauti(spr, j-1);
          elementas_sar_prisk (spr, j-1, elementas_sar_gauti(spr, j));
          elementas_sar_prisk (spr, j, t);
          spausdinti_sar2kr_pr (spr)
        end;

  writeln ('Rusiuojam mazejanciai masyva-sarasa...pabaiga')
end;


{------------------------------------------------------------}

{ apsirasom sarasa }
var pr, pb : sarasas2kr;

begin
  writeln;
  writeln ('Pradedama programa...');
  pr := nil;
  pb := nil;

  // burbulas didejanciai masyvui-sarasui
  writeln;
  writeln ('--- Masyvui-sarasui didejanciai ---');
  uzpildyti_sar2kr (pr, pb);
  write ('Nerusiuotas:');
  spausdinti_sar2kr_pr (pr);
  bubble_mas_sar_did (pr, pb);
  write ('Surusiuotas:');
  spausdinti_sar2kr_pr (pr);

  // burbulas mazejanciai masyvui-sarasui
  writeln;
  writeln ('--- Masyvui-sarasui mazejanciai ---');
  uzpildyti_sar2kr (pr, pb);
  write ('Nerusiuotas:');
  spausdinti_sar2kr_pr (pr);
  bubble_mas_sar_maz (pr, pb);
  write ('Surusiuotas:');
  spausdinti_sar2kr_pr (pr);

  writeln;
  writeln ('Baigta programa.')
end.
